package com.bizvane.members.feign.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
@Data
public class PageInfo<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    private List<T> list;

    // 当前页
    private int pageNum;
    // 每页的数量
    private int pageSize;

    // 总页数
    private int pages;

    // 总页数
    private long total;


    public PageInfo() {}


    public PageInfo(int pageNum, int pageSize, long total, List<T> list) {
        this.list = list;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
        this.pages = (int) Math.ceil((double) total / pageSize);;
    }

}
